/********************************************
; File: Loader.h
;
;
; Copyright Apple Computer, Inc.1986-89
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#include <Types.h>
#endif

#ifndef __LOADER__
#define __LOADER__

#define idNotFound 0x1101 /*error - segment/application/entry not found */
#define idNotLoadFile 0x1104 /*error - file is not a load file */
#define idBusyErr 0x1105 /*error - system loader is busy */
#define idFilVersErr 0x1107 /*error - file version error */
#define idUserIDErr 0x1108 /*error - user ID error */
#define idSequenceErr 0x1109 /*error - segnum out of sequence */
#define idBadRecordErr 0x110A /*error - illegal load record found */
#define idForeignSegErr 0x110B /*error - segment is foreign */
struct InitialLoadOutputRec {
   Word userID; /*  */
   Pointer startAddr; /*  */
   Word dPageAddr; /*  */
   Word buffSize; /*  */
} ;
typedef struct InitialLoadOutputRec InitialLoadOutputRec, *InitialLoadOutputRecPtr;
struct RestartOutRec {
   Word userID; /*  */
   Pointer startAddr; /*  */
   Word dPageAddr; /*  */
   Word buffSize; /*  */
} ;
typedef struct RestartOutRec RestartOutRec, *RestartOutRecPtr;
struct LoadSegNameOut {
   Pointer segAddr; /*  */
   Word fileNum; /*  */
   Word segNum; /*  */
} ;
typedef struct LoadSegNameOut LoadSegNameOut, *LoadSegNameOutPtr;
struct UnloadSegOutRec {
   Word userID; /*  */
   Word fileNum; /*  */
   Word segNum; /*  */
} ;
typedef struct UnloadSegOutRec UnloadSegOutRec, *UnloadSegOutRecPtr;
extern pascal void LoaderInitialization () inline(0x0111,dispatcher);
extern pascal void LoaderStartUp () inline(0x0211,dispatcher);
extern pascal void LoaderShutDown () inline(0x0311,dispatcher);
extern pascal Word LoaderVersion () inline(0x0411,dispatcher);
extern pascal void LoaderReset () inline(0x0511,dispatcher);
extern pascal Boolean LoaderStatus () inline(0x0611,dispatcher);
extern pascal void GetLoadSegInfo () inline(0x0F11,dispatcher);
extern pascal Word GetUserID () inline(0x1011,dispatcher);
extern pascal Word GetUserID2 () inline(0x2111,dispatcher);
extern InitialLoadOutputRec InitialLoad ();
extern InitialLoadOutputRec InitialLoad2 ();
extern pascal Pointer LGetPathname () inline(0x1111,dispatcher);
extern pascal Pointer LGetPathname2 () inline(0x2211,dispatcher);
extern pascal Pointer GetPathname () inline(0x1111,dispatcher);
extern pascal Pointer GetPathname2 () inline(0x2211,dispatcher);
extern pascal void RenamePathname () inline(0x1311,dispatcher);
extern LoadSegNameOut LoadSegName ();
extern pascal Pointer LoadSegNum () inline(0x0B11,dispatcher);
extern RestartOutRec Restart ();
extern UnloadSegOutRec UnloadSeg ();
extern pascal void UnloadSegNum () inline(0x0C11,dispatcher);
extern pascal Word UserShutDown () inline(0x1211,dispatcher);
#endif
