/********************************************
; File: List.h
;
;
; Copyright Apple Computer, Inc.1986-89
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#include <Types.h>
#endif

#ifndef __QUICKDRAW__
#include <Quickdraw.h>
#endif

#ifndef __EVENT__
#include <Event.h>
#endif

#ifndef __CONTROL__
#include <Control.h>
#endif

#ifndef __LIST__
#define __LIST__

#define cString 0x0001 /*ListType bit mask - null terminated string type */
#define LIST_STRG 0x0001 /*ListType bit mask - null terminated string type */
#define selectOnlyOne 0x0002 /*ListType bit mask - only one selection allowed */
#define LIST_SELECT 0x0002 /*ListType bit mask - single selection only */
#define memDisabled 0x40 /*memFlag - Sets member flag to disabled */
#define memSelected 0x80 /*memFlag - Sets member flag to selected */
struct LColorTable {
   Word listFrameClr; /* Frame color */
   Word listNorTextClr; /* Unhighlighted text color */
   Word listSelTextClr; /* Highlighted text color */
   Word listNorBackClr; /* Unhighlighted background color */
   Word listSelBackClr; /* Highlighted backgraound color */
} ;
typedef struct LColorTable LColorTable, *LColorTablePtr, **LColorTableHndl;
struct MemRec {
   Pointer memPtr; /* Pointer to string, or custom */
   Byte memFlag; /* Bit Flag */
} ;
typedef struct MemRec MemRec, *MemRecPtr, **MemRecHndl;
struct ListCtlRec {
   CtlRecHndl ctlNext; /* Handle of Next Control */
   GrafPortPtr ctlOwner; /* Window owner */
   Rect ctlRect; /* Enclosing Rect */
   Byte ctlFlag; /* Bit 7 visible, Bit 0 string type, Bit 1 multiple */
   Byte ctlHilite; /* (not used) */
   Word ctlValue; /* First member in display */
   LongProcPtr ctlProc; /* Address of list definition procedure */
   LongProcPtr ctlAction; /* Address of list action procedure */
   LongWord ctlData; /* Low = view size, High = total members */
   LongWord ctlRefCon; /* Not used */
   LColorTablePtr ctlColor; /* Null for default colors */
   VoidProcPtr ctlMemDraw; /* Address of routine to draw members */
   Word ctlMemHeight; /* Member's Height in Pixels */
   Word ctlMemSize; /* Bytes in member record */
   MemRecPtr ctlList; /* Adress of first member record in array */
   CtlRecHndl ctlListBar; /* Handle of list contrlo's scroll bar control */
} ;
typedef struct ListCtlRec ListCtlRec, *ListCtlRecPtr, **ListCtlRecHndl;
struct ListRec {
   Rect listRect; /* Enclosing Rectangle */
   Word listSize; /* Number of List Members */
   Word listView; /* Max Viewable members */
   Word listType; /* Bit Flag */
   Word listStart; /* First member in view */
   CtlRecHndl listCtl; /* List control's handle */
   VoidProcPtr listDraw; /* Address of Custom drawing routine */
   Word listMemHeight; /* Height of list members */
   Word listMemSize; /* Size of Member Records */
   MemRecPtr listPointer; /* Pointer to first element in MemRec array */
   LongWord listRefCon; /* becomes Control's refCon */
   BarColorsPtr listScrollClr; /* Color table for list's scroll bar */
} ;
typedef struct ListRec ListRec, *ListRecPtr, **ListRecHndl;
extern pascal void ListBootInit () inline(0x011C,dispatcher);
extern pascal void ListStartup () inline(0x021C,dispatcher);
extern pascal void ListShutDown () inline(0x031C,dispatcher);
extern pascal Word ListVersion () inline(0x041C,dispatcher);
extern pascal void ListReset () inline(0x051C,dispatcher);
extern pascal Boolean ListStatus () inline(0x061C,dispatcher);
extern pascal ListCtlRecHndl CreateList () inline(0x091C,dispatcher);
extern pascal void DrawMember () inline(0x0C1C,dispatcher);
extern pascal LongProcPtr GetListDefProc () inline(0x0E1C,dispatcher);
extern pascal void NewList () inline(0x101C,dispatcher);
extern pascal MemRecPtr NextMember () inline(0x0B1C,dispatcher);
extern pascal MemRecPtr ResetMember () inline(0x0F1C,dispatcher);
extern pascal void SelectMember () inline(0x0D1C,dispatcher);
extern pascal void SortList () inline(0x0A1C,dispatcher);
extern pascal void DrawMember2 () inline(0x111C,dispatcher);
extern pascal Word NextMember2 () inline(0x121C,dispatcher);
extern pascal Word ResetMember2 () inline(0x131C,dispatcher);
extern pascal void SelectMember2 () inline(0x141C,dispatcher);
extern pascal void SortList2 () inline(0x151C,dispatcher);
extern pascal void NewList2 () inline(0x161C,dispatcher);
#endif
