/********************************************
; File: IntMath.h
;
;
; Copyright Apple Computer, Inc.1986-89
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#include <Types.h>
#endif

#ifndef __INTMATH__
#define __INTMATH__

#define imBadInptParam 0x0B01 /*error - bad input parameter */
#define imIllegalChar 0x0B02 /*error - Illegal character in string */
#define imOverflow 0x0B03 /*error - integer or long integer overflow */
#define imStrOverflow 0x0B04 /*error - string overflow */
#define minLongint 0x80000000 /*Limit - minimum negative signed long integer */
#define minFrac 0x80000000 /*Limit - pinned value for negative Frac overflow */
#define minFixed 0x80000000 /*Limit - pinned value for negative Fixed overflow */
#define minInt 0x8000 /*Limit - Minimum negative signed integer */
#define maxInt 0x7FFF /*Limit - Maximum positive signed integer */
#define maxUInt 0xFFFF /*Limit - Maximum positive unsigned integer */
#define maxLongint 0x7FFFFFFF /*Limit - maximum positive signed Longint */
#define maxFrac 0x7FFFFFFF /*Limit - pinned value for positive Frac overflow */
#define maxFixed 0x7FFFFFFF /*Limit - pinned value for positive Fixed overflow */
#define maxULong 0xFFFFFFFFL /*Limit - maximum unsigned Long */
#define unsignedFlag 0x0000 /*SignedFlag -  */
#define signedFlag 0x0001 /*SignedFlag -  */
struct IntDivRec {
   Word quotient; /* quotient from SDivide */
   Word remainder; /* remainder from SDivide */
} ;
typedef struct IntDivRec IntDivRec, *IntDivRecPtr;
struct LongDivRec {
   Longint quotient; /* Quotient from LongDiv */
   Longint remainder; /* remainder from LongDiv */
} ;
typedef struct LongDivRec LongDivRec, *LongDivRecPtr;
typedef LongDivRec DivRec, *DivRecPtr; /* for backward compatability */
struct LongMulRec {
   Longint lsResult; /* low 2 words of product */
   Longint msResult; /* High 2 words of product */
} ;
typedef struct LongMulRec LongMulRec, *LongMulRecPtr;
struct WordDivRec {
   Word quotient; /* Quotient from UDivide */
   Word remainder; /* remainder from UDivide */
} ;
typedef struct WordDivRec WordDivRec, *WordDivRecPtr;
extern pascal void IMBootInit() inline(0x010B,dispatcher);
extern pascal void IMStartUp() inline(0x020B,dispatcher);
extern pascal void IMShutDown() inline(0x030B,dispatcher);
extern pascal Word IMVersion() inline(0x040B,dispatcher);
extern pascal void IMReset() inline(0x050B,dispatcher);
extern pascal Boolean IMStatus() inline(0x060B,dispatcher);
extern pascal Word Dec2Int() inline(0x280B,dispatcher);
extern pascal Longint Dec2Long() inline(0x290B,dispatcher);
extern pascal Frac Fix2Frac() inline(0x1C0B,dispatcher);
extern pascal Longint Fix2Long() inline(0x1B0B,dispatcher);
extern pascal void Fix2X() inline(0x1E0B,dispatcher);
extern pascal Fixed FixATan2() inline(0x170B,dispatcher);
extern pascal Fixed FixDiv() inline(0x110B,dispatcher);
extern pascal Fixed FixMul() inline(0x0F0B,dispatcher);
extern pascal Fixed FixRatio() inline(0x0E0B,dispatcher);
extern pascal Word FixRound() inline(0x130B,dispatcher);
extern pascal Fixed Frac2Fix() inline(0x1D0B,dispatcher);
extern pascal void Frac2X() inline(0x1F0B,dispatcher);
extern pascal Frac FracCos() inline(0x150B,dispatcher);
extern pascal Frac FracDiv() inline(0x120B,dispatcher);
extern pascal Frac FracMul() inline(0x100B,dispatcher);
extern pascal Frac FracSin() inline(0x160B,dispatcher);
extern pascal Frac FracSqrt() inline(0x140B,dispatcher);
extern pascal Word Hex2Int() inline(0x240B,dispatcher);
extern pascal LongWord Hex2Long() inline(0x250B,dispatcher);
extern pascal LongWord HexIt() inline(0x2A0B,dispatcher);
extern pascal Word HiWord() inline(0x180B,dispatcher);
extern pascal void Int2Dec() inline(0x260B,dispatcher);
extern pascal void Int2Hex() inline(0x220B,dispatcher);
extern pascal void Long2Dec() inline(0x270B,dispatcher);
extern pascal Fixed Long2Fix() inline(0x1A0B,dispatcher);
extern pascal void Long2Hex() inline(0x230B,dispatcher);
extern LongDivRec LongDivide();
extern LongMulRec LongMul();
extern pascal Word LoWord() inline(0x190B,dispatcher);
extern pascal Longint Multiply() inline(0x090B,dispatcher);
extern IntDivRec SDivide();
extern WordDivRec UDivide();
extern pascal Longint X2Fix() inline(0x200B,dispatcher);
extern pascal Longint X2Frac() inline(0x210B,dispatcher);
#endif
