/*
  Functions to get suitably aligned core memory from the
  environment and return it (if possible).
*/

/*
  Simple implementation, assuming a single memory block allocated
  as heap, e.g. for stand-alone systems. Unix systems might provide brk
  or sbrk system calls.
*/

#include <stdlib.h>

#if __MNEAR==1
#include "Types.h"
extern pascal __far void * __NewHandle () inline(0x0902,dispatcher);
extern pascal __far void * __FindHandle () inline(0x1A02,dispatcher);
#define MEM_ATTR 0x4011 /* attrFixed, attrNoCross, attrBank */
#else
#define MEM_ATTR 0x4010 /* attrFixed, attrNoCross */
#endif

#include "Memory.h"

static Word uid;

void *__getcore(size_t s)
{
  __far void *__far *p;
  if(!uid){
   uid=MMStartUp()|0x100;
  }
  p=NewHandle((unsigned long)s,uid,MEM_ATTR,0l);
  if(p==0||_toolErr) return 0;
  return *p;
}

void _EXIT_1_malloc(void)
{
  DisposeAll(uid);
  MMShutDown(uid&~0x100);
}

void __freecore(void *p,size_t s)
{
  DisposeHandle(FindHandle((__far void *)p));
}
