RAMSTART   =? 0x0000;
RAMEND     =? 0x8000;
STACKLEN   =? 0x0100;
STACKSTART = RAMEND - STACKLEN;

PROVIDE(__VLINK_LIB_MPET4 =? 0);
MSHW = __VLINK_LIB_MPET4;
ZS1 =? !(!MSHW) * 0x02 + !MSHW * 0x02;
ZE1 =? !(!MSHW) * 0x1f + !MSHW * 0x8d;
ZS2 =? !(!MSHW) * 0x28 + !MSHW * 0x00;
ZE2 =? !(!MSHW) * 0x4a + !MSHW * 0x00;
ZS3 =? !(!MSHW) * 0x6e + !MSHW * 0x00;
ZE3 =? !(!MSHW) * 0x8d + !MSHW * 0x00;

MEMORY
{
 zero1 : org = ZS1, len = ZE1-ZS1
 zero2 : org = ZS2, len = ZE2-ZS2
 zero3 : org = ZS3, len = ZE3-ZS3

 ram : org = 0x401, len=STACKSTART-0x401
 stack : org = STACKSTART, len=STACKLEN
}

SECTIONS
{
  text : {*(text)} >ram
  .dtors : { *(.dtors) } > ram
  .ctors : { *(.ctors) } > ram
  rodata : {*(rodata)} >ram
  data: {*(data)} >ram
  init : {*(init)} >ram
  bss (NOLOAD): {*(bss)} >ram
  /* data copy section + zpage save */

  zpage1 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero1
  zpage2 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero2
  zpage3 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero3

  __BB = ADDR(bss);
  __BE = ADDR(bss)+SIZEOF(bss);
  __ZB = ADDR(zpage);
  __ZS = SIZEOF(zpage);
  __ZC = ADDR(bss)+SIZEOF(bss)+SIZEOF(data);
  __DB = ADDR(data);
  __DE = ADDR(data)+SIZEOF(data);
  __DC = ADDR(bss)+SIZEOF(bss);
  __SE = STACKSTART+STACKLEN;
  ___heap = ADDR(bss)+SIZEOF(bss)+SIZEOF(data)+SIZEOF(zpage);
  ___heapend = STACKSTART-1;
}
