RAMSTART =? 0x1000;
RAMEND =? 0x8000;
STACKLEN   =? 0x100;
PROVIDE(__VLINK_LIB_MC16 =? 0);
MSHW = __VLINK_LIB_MC16;
ZS1 =? !(!MSHW) * 0x02 + !MSHW * 0x02;
ZE1 =? !(!MSHW) * 0x22 + !MSHW * 0x90;
ZS2 =? !(!MSHW) * 0x2b + !MSHW * 0x00;
ZE2 =? !(!MSHW) * 0x4d + !MSHW * 0x00;
ZS3 =? !(!MSHW) * 0x73 + !MSHW * 0x00;
ZE3 =? !(!MSHW) * 0x90 + !MSHW * 0x00;


MEMORY
{
 zero1 : org = ZS1, len = ZE1-ZS1
 zero2 : org = ZS2, len = ZE2-ZS2
 zero3 : org = ZS3, len = ZE3-ZS3
 ram : org = RAMSTART+1, len=RAMEND-RAMSTART-STACKLEN-1
}



SECTIONS
{
  .rdummy 0 : { *(.rdummy) }
  text : {*(text)} >ram
  .dtors : { *(.dtors) } > ram
  .ctors : { *(.ctors) } > ram
  rodata : {*(rodata)} >ram
  data: {*(data)} >ram
  init : {*(init)} >ram
  zpage1 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero1
  zpage2 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero2
  zpage3 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero3
  bss (NOLOAD): {*(bss)} >ram

  __BB = ADDR(bss);
  __BE = ADDR(bss)+SIZEOF(bss);
  __SE = __BE+STACKLEN;
  __ZB = ADDR(zpage1);
  __ZS = SIZEOF(zpage1);
  __ZC = __SE+SIZEOF(data);
  __DB = ADDR(data);
  __DE = ADDR(data)+SIZEOF(data);
  __DC = __SE;
  ___heap = __ZC+SIZEOF(zpage1);
  ___heapend = RAMEND;
}
