RAMSTART =? 0x1000;
RAMEND =? 0x1e00;
STACKLEN   =? 0x100;
PROVIDE(__VLINK_LIB_MVIC20 =? 0);
MSHW = __VLINK_LIB_MVIC20 ;
ZS1 =? !(!MSHW) * 0x02 + !MSHW * 0x02;
ZE1 =? !(!MSHW) * 0x22 + !MSHW * 0x90;
ZS2 =? !(!MSHW) * 0x00 + !MSHW * 0x00;
ZE2 =? !(!MSHW) * 0x00 + !MSHW * 0x00;
ZS3 =? !(!MSHW) * 0x00 + !MSHW * 0x00;
ZE3 =? !(!MSHW) * 0x00 + !MSHW * 0x00;

MEMORY
{
 zero1 : org = ZS1, len = ZE1-ZS1
 zero2 : org = ZS2, len = ZE2-ZS2
 zero3 : org = ZS3, len = ZE3-ZS3
 ram : org = RAMSTART+1, len=RAMEND-RAMSTART-STACKLEN-1
}

SECTIONS
{
  .rdummy 0 : { *(.rdummy) }
  header : {
     SHORT(RAMSTART+12);
     SHORT(123);
     BYTE(0x9e);
     START=RAMSTART+14;
     BYTE(((START/10000)%10)+48);
     BYTE(((START/1000)%10)+48);
     BYTE(((START/100)%10)+48);
     BYTE(((START/10)%10)+48);
     BYTE(((START)%10)+48);
     BYTE(0);
     SHORT(0);
  } >ram
  text : {*(text)} >ram
  .dtors : { *(.dtors) } > ram
  .ctors : { *(.ctors) } > ram
  rodata : {*(rodata)} >ram
  data: {*(data)} >ram
  init : {*(init)} >ram
  zpage1 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero1
  zpage2 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero2
  zpage3 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero3
  bss (NOLOAD): {*(bss)} >ram

  __BB = ADDR(bss);
  __BE = ADDR(bss)+SIZEOF(bss);
  __ZB = ADDR(zpage1);
  __ZS = SIZEOF(zpage1);
  __ZC = ADDR(bss)+SIZEOF(bss)+SIZEOF(data);
  __DB = ADDR(data);
  __DE = ADDR(data)+SIZEOF(data);
  __DC = ADDR(bss)+SIZEOF(bss);
  __SE = __DC+SIZEOF(data)+STACKLEN;
  ___heap = __SE;
  ___heapend = RAMEND;
}
