LOADADDR =? 0x1200;
RAMSTART =? 0x2000;
RAMEND =? 0x8000;
STACKLEN   =? 0x200;
PROVIDE(__VLINK_LIB_MVIC20 =? 0);
MSHW = __VLINK_LIB_MVIC20 ;
ZS1 =? !(!MSHW) * 0x02 + !MSHW * 0x02;
ZE1 =? !(!MSHW) * 0x22 + !MSHW * 0x90;
ZS2 =? !(!MSHW) * 0x2b + !MSHW * 0x00;
ZE2 =? !(!MSHW) * 0x42 + !MSHW * 0x00;
ZS3 =? !(!MSHW) * 0x73 + !MSHW * 0x00;
ZE3 =? !(!MSHW) * 0x90 + !MSHW * 0x00;

MEMORY
{
 zero1 : org = ZS1, len = ZE1-ZS1
 zero2 : org = ZS2, len = ZE2-ZS2
 zero3 : org = ZS3, len = ZE3-ZS3
 ram : org = RAMSTART+1, len=RAMEND-RAMSTART-STACKLEN-1
 load : org = LOADADDR+1, len=0xffff
}

SECTIONS
{
  .rdummy 0 : { *(.rdummy) }
  header : {
     SHORT(LOADADDR+12);
     SHORT(123);
     BYTE(0x9e);
     START=LOADADDR+14;
     BYTE(((START/10000)%10)+48);
     BYTE(((START/1000)%10)+48);
     BYTE(((START/100)%10)+48);
     BYTE(((START/10)%10)+48);
     BYTE(((START)%10)+48);
     BYTE(0);
     SHORT(0);
  } >ram AT>load

  text : {*(text)} >ram AT>load
  .dtors : { *(.dtors) } > ram AT>load
  .ctors : { *(.ctors) } > ram AT>load
  rodata : {*(rodata)} >ram AT>load
  data: {*(data)} >ram AT>load
  init : {*(init)} >ram AT>load
  zpage1 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero1
  zpage2 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero2
  zpage3 (NOLOAD) : {*(zpage) *(zp1) *(zp2)} >zero3
  bss (NOLOAD): {*(bss)} >ram

  __BB = ADDR(bss);
  __BE = ADDR(bss)+SIZEOF(bss);
  __SE = __BE+STACKLEN;
  ___heap = __SE;
  ___heapend = RAMEND;
  __CS = ADDR(bss) - RAMSTART + LOADADDR;
  __CC = ADDR(bss);
  __CE = RAMSTART;
}
