#ifndef __LIBSYS_H
#define __LIBSYS_H 1

unsigned int __write(int,const char *,unsigned int);
unsigned int __read(int,char *,unsigned int);
long __seek(int,long,int);


__regsused("") void __chrout(__reg("a") unsigned char x)="\tora\t#128\n\tjsr\t$FDED";
__regsused("") char __chrin(void) = "\tjsr\t$FD0C";


#define PDOS_GET_BUF 0xd3
#define PDOS_SET_BUF 0xd2
#define PDOS_GET_EOF 0xd1
#define PDOS_SET_EOF 0xd0
#define PDOS_GET_MARK 0xcf
#define PDOS_SET_MARK 0xce
#define PDOS_FLUSH 0xcd
#define PDOS_CLOSE 0xcc
#define PDOS_WRITE 0xcb
#define PDOS_READ 0xca
#define PDOS_OPEN 0xc8
#define PDOS_GET_PREFIX 0xc7
#define PDOS_SET_PREFIX 0xc6
#define PDOS_RENAME 0xc2
#define PDOS_DESTROY 0xc1
#define PDOS_CREATE 0xc0

#define __pdos_call(x) __pdos_call2(x)
#define __pdos_call2(x) __asm("\tjsr\t$bf00\n\tdb\t" #x "\n\tdw\t___pdos_cmd\n\tsta\t___pdos_err")

typedef union {
struct {
 char cnt;
 void *name;
 char access;
 char file_type;
 unsigned int aux_type;
 char storage_type;
 unsigned int create_date;
 unsigned int create_time;
} create;
struct {
 char cnt;
 void *name;
} destroy;
struct {
 char cnt;
 void *name;
 void *new_name;
} rename;
struct {
 char cnt;
 void *name;
 void *io_buffer;
 char ref_num;
} open;
struct {
 char cnt;
 char ref_num;
 void *data_buffer;
 unsigned int request_count;
 unsigned int trans_count;
} read;
struct {
 char cnt;
 char ref_num;
 void *data_buffer;
 unsigned int request_count;
 unsigned int trans_count;
} write;
struct {
 char cnt;
 char ref_num;
} close;
struct {
 char cnt;
 char ref_num;
} flush;
struct {
 char cnt;
 char ref_num;
 unsigned long position; /* only 3 bytes used */
} set_mark;
struct {
 char cnt;
 char ref_num;
 unsigned long position; /* only 3 bytes used */
} get_mark;
struct {
 char cnt;
 char ref_num;
 unsigned long position; /* only 3 bytes used */
} set_eof;  
struct {
 char cnt;
 char ref_num;
 unsigned long position; /* only 3 bytes used */
} get_eof;  

struct {
 char cnt;
 char ref_num;
 void *io_buffer;
} get_buf;
struct {
 char cnt;
 void *data_buffer;
} get_prefix;
struct {
 char cnt;
 void *name;
} set_prefix;

} pdos_cmd;

extern pdos_cmd __pdos_cmd;
extern char __pdos_err;

#endif

